/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.VariableIntPower;
import java.util.Collection;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Difficulty;

public class DamageOverTimePower
extends VariableIntPower {
    private final int damageTickInterval;
    private final int beginDamageIn;
    private final float damageAmountEasy;
    private final float damageAmount;
    private final DamageSource damageSource;
    private final Enchantment protectingEnchantment;
    private final float protectionEffectiveness;
    private int outOfDamageTicks;

    public DamageOverTimePower(PowerType<?> type, PlayerEntity player, int beginDamageIn, int damageInterval, float damageAmountEasy, float damageAmount, DamageSource damageSource, Enchantment protectingEnchantment, float protectionEffectiveness) {
        super(type, player, beginDamageIn, 0, Math.max(damageInterval, beginDamageIn));
        this.damageSource = damageSource;
        this.beginDamageIn = beginDamageIn;
        this.damageAmount = damageAmount;
        this.damageAmountEasy = damageAmountEasy;
        this.protectingEnchantment = protectingEnchantment;
        this.protectionEffectiveness = protectionEffectiveness;
        this.damageTickInterval = damageInterval;
        this.setTicking(true);
    }

    @Override
    public int getMax() {
        return Math.max(super.getMax(), this.getDamageBegin());
    }

    public int getDamageBegin() {
        int prot = this.getProtection();
        if (prot >= 64) {
            return 24000;
        }
        prot = (int)((float)(prot * 2 * 20) * this.protectionEffectiveness);
        return this.beginDamageIn + prot;
    }

    @Override
    public void tick() {
        if (this.isActive()) {
            this.doDamage();
        } else {
            this.resetDamage();
        }
    }

    public void doDamage() {
        this.outOfDamageTicks = 0;
        if (this.getValue() <= 0) {
            this.setValue(this.damageTickInterval);
            this.player.func_70097_a(this.damageSource, this.player.field_70170_p.func_175659_aa() == Difficulty.EASY ? this.damageAmountEasy : this.damageAmount);
        } else {
            this.decrement();
        }
    }

    public void resetDamage() {
        if (this.outOfDamageTicks >= 20) {
            this.setValue(this.getDamageBegin());
        } else {
            ++this.outOfDamageTicks;
        }
    }

    private int getProtection() {
        if (this.protectingEnchantment == null) {
            return 0;
        }
        Map enchantedItems = this.protectingEnchantment.func_222181_a((LivingEntity)this.player);
        Collection iterable = enchantedItems.values();
        int i = 0;
        for (ItemStack itemStack : iterable) {
            i += EnchantmentHelper.func_77506_a((Enchantment)this.protectingEnchantment, (ItemStack)itemStack);
        }
        return i * enchantedItems.size();
    }
}

